$(document).ready(function($){

    var slider = new MasterSlider();
 
    slider.control('thumblist' , {autohide:false, dir:'v', type:'tabs', align:'right', margin:0, space:6, width:142, height:100, arrows:false, inset: true});
    slider.control('arrows' , {autohide: false, });

    slider.setup('masterslider' , {
        width: 1024,
        height: 768,
        view: 'mask',
        layout: 'fullscreen',
        speed: 20,
        loop: true,
        //autoplay: true,
        fillMode: 'fill',
        dir: 'v'
    });



    var $elem = $('.master-slider');

    if ($elem.length > 0) {
        slider.api.addEventListener(MSSliderEvent.INIT , function(){
            var $controlsWrapper = $elem.find('.ms-container');
            var $controlUI = $('<div class="ms-controlls"></div>').appendTo($controlsWrapper);

            $controlUI.append($controlsWrapper.find('.ms-nav-prev'));

            var counterMarkup='<div class="ms-counter">'+
                            '<span class="counter-current">'+(slider.api.index()+1)+'</span>'+
                            '<span class="counter-divider">/</span>'+
                            '<span class="counter-total">'+slider.api.count()+'</span>'+
                          '</div>';
            var $counterMarkup = $(counterMarkup).appendTo($controlUI);
            var $current = $counterMarkup.find('.counter-current');


            function sliderCounter($elem,slider,$current) {
                slider.api.addEventListener(MSSliderEvent.CHANGE_START , function(){
                    $current.html(''+(slider.api.index()+1)+'');
                });
            }
            sliderCounter($elem,slider,$current);

            slider.api.resume();

            $controlUI.append($controlsWrapper.find('.ms-nav-next'));
        });
    }
    
});