<?php
/*
	Stempora web framework
	copyright (c) 2002-2013 Stempora
		web:  www.oxylus.ro
		mail: support@oxylus.ro		

	$Id: name.php,v 0.0.1 dd/mm/yyyy hh:mm:ss oxylus Exp $
	description
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CSkinEditor extends CPlugin{
	
	var $tplvars; 

	function CSkinEditor() {
		//$this->CPlugin($db, $tables , $templates);
		$this->name = "skineditor";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == $this->name) {
			$sub = $_GET["sub"];
			$action = $_GET["action"];

			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule($this->name);
			switch ($sub) {
				case "landing":
					urlredirect("index.php?mod=skineditor&sub=settings");
				break;

				case "skins":
				case "overlays":
					$_SESS["skineditor"] = "";
				
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$this->PrepareFields($data->forms["forms"]);

					$data->functions = array( 
							"onstore" => array(&$this , "StoreRecord"),
					);					

					return $data->DoEvents();
				break;

				case "duplicate":
					return $this->Duplicate();
				break;

				case "settings":
						$data = new CFormSettings($this->forms_path  . $sub . ".xml" ,$_CONF["forms"]["admintemplate"] , $this->db,$this->tables);
						$this->PrepareDashboard($data->form);

						if ($data->Done()) {


							$skin = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:skins']} WHERE skin_id=%d" , array($_POST['set_skin']));

							$this->vars->SetVars(
								array(
									"set_skin"			=> $_POST["set_skin"],
									"set_skin_type"		=> $_POST["set_skin_type"],
									"set_menu_sticky"	=> $_POST["set_menu_sticky"],
									"set_style_boxed"	=> $_POST["set_style_boxed"],
									"set_copyright_bar"	=> $_POST["set_copyright_bar"],
									"set_preloader"		=> $_POST["set_preloader"],
									"set_menu_style"	=> $_POST["set_menu_style"],
								)
							);
						}
						
						return $data->Show(							
							$this->vars->GetVars(
								CForm::KeyFields($data->form)
							)
						
						);

				break;

				case "preview":
					return $this->Preview();
				break;

				case "browsefonts":
					return $this->BrowseFonts();
				break;

				case "filemanager":

					return $this->FileManager();
				break;
			}
		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreRecord($record) {

		if ($record["overlay_id"]) {

			$this->StoreOverlays();
		}
		


		if ($record["skin_id"]) {
			CFile::Save("../upload/skins/{$record[skin_id]}.css" , $record["skin_css"]);
		}
		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreOverlays() {
		$overlays = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['core:skins_overlays']}");

		if (is_array($overlays)) {

			$tpl = new CTemplateDynamic($this->tpl_path . "admin.overlays.htm");

			foreach ($overlays as $key => $val) {
				$val["image"] = "./overlays/{$val[overlay_id]}.png";

				$overlays_htm .= $tpl->blockReplace("Item" , $val);
			}
			
		}
		

		
		CFile::Save("../upload/skins/overlays.css" , $overlays_htm);
	}
	
	

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Duplicate() {

		$item = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:skins']} WHERE skin_id={$_GET['skin_id']}");

		if (!is_array($item)) {
			return "Invalid link !";
		}

		unset($item["skin_id"]);
		unset($item["skin_modules"]);
		unset($item["skin_default"]);
		unset($item["skin_system"]);
		unset($item["skin_modules_global"]);

		$item["skin_name"] .= " ( Copy )";

		$sid = $this->db->QueryInsert(
			$this->tables['core:skins'] , 
			$item
		);

		
		//redirect to details page
		urlredirect(
			"index.php?mod=skineditor&sub=landing&skin_id={$sid}&action=edit&returnurl=" . 
				urlencode("index.php?mod=skineditor&sub=landing")
		);
				
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Preview() {
		global $_CONF , $_SESS;

		CFile::Save("../upload/skins/preview.css" , $_POST["skin_css"]);


		$_SESS["skineditor"] = $_POST["skin_base"];

		echo $_CONF["url"];
		die();
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function BrowseFonts() {
		global $base;

		$path  = "../assets/css/";
		$tpl = new CTemplateDynamic($this->tpl_path . "fonts.htm");
		$font = array();

		$fonts = array(
			1	=> array(
				"key"	=> "1",
				"file"	=> $path . "font.icomoon.css",
				"title"	=> "IcoMoon Collection",
				"shortcode"	=> "[icomoon=",
			),
			2	=> array(
				"key"	=> "2",
				"file"	=> $path . "font.fontawesome.css",
				"title"	=> "FontAwesome Collection",
				"shortcode"	=> "[fontawesome=",
			),

		);

		$cur = explode(" " , $_GET["sel"]);

		foreach ($fonts as $k => $font) {

			if (file_exists($font["file"])) {
				$file = file($font["file"]);

				foreach ($file as $key => $val) {

					if (stristr($val , "icon-") && stristr($val , ":before {")) {

						$icon = trim(str_replace(array("." , ":before {") ,array("" , "") ,  $val));

						$fonts[$k]["icons"][] = array(
								"icon" => $icon,
								"icon_class" => "icomoon",
								"class"	=> ($icon == $cur[1]) && $cur[0] == "icomoon" ? "selected" : "",
						);
					}			

					if (stristr($val , "fa-") && stristr($val , ":before {")) {
						$icon = trim(str_replace(array("." , ":before {") ,array("" , "") ,  $val));


						$fonts[$k]["icons"][] = array(
								"icon" => $icon ,
								"icon_class" => "fa",
								"class"	=> ($icon == $cur[1]) && $cur[0] == "fa" ? "selected" : "",
						);
					}			

				}

			} else {
				unset($fonts[$k]);
			}
		
		}

//		debug($fonts,1);

		foreach ($fonts as $key => $val) {
			$fonts[$key]["items"] = CTemplateStatic::REplace(
				$base->html->table(
					$tpl , 
					"", 
					$val["icons"]
				),
				$val
			);
		}
		
		


		$content = $tpl->blockReplace(
			"Main" , 
			array(
				"im"	=> $im ? '<link rel="stylesheet" href="../assets/css/font.icomoon.css" />' : '',
				"fa"	=> $im ? '<link rel="stylesheet" href="../assets/css/font.fontawesome.css" />' : '',

					
				"fonts"	=> $base->html->Table(
					$tpl , 
					"Font" , 
					$fonts
				),

				"fontslink"	=> $base->html->Table(
					$tpl , 
					"FontLink" , 
					$fonts
				),

				"button"	=> $_GET["field"] ? $tpl->blockReplace("Script" , $_GET) : "",

				"control"	=> $tpl->blockReplace($_GET["field"] ? "ControlText" : "ControlShortcode"),

			)
		);

		die($content);
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function FileManager() {

		$tpl = new CTemplateDynamic($this->tpl_path . "filemanager.htm");

		echo $tpl->blockreplace(
			"Main",
			array()
		);
		die();
	}
	
}

?>