DROP TABLE IF EXISTS `site_plugin_users`;
CREATE TABLE IF NOT EXISTS `site_plugin_users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_fbid` bigint(20) NOT NULL,
  `user_date` int(11) NOT NULL,
  `user_key` varchar(32) NOT NULL,
  `user_reserved` int(1) NOT NULL,
  `user_key_code` varchar(32) NOT NULL,
  `user_key_date` varchar(32) NOT NULL,
  `user_password` varchar(32) NOT NULL,
  `user_password_date` int(11) NOT NULL,
  `user_login` varchar(50) NOT NULL,
  `user_email` varchar(255) NOT NULL,
  `user_status` int(1) NOT NULL,
  `user_first_name` varchar(100) NOT NULL,
  `user_last_name` varchar(100) NOT NULL,
  `user_groups` text NOT NULL,
  `user_membership` int(11) NOT NULL,
  `user_membership_start` int(11) NOT NULL,
  `user_membership_expire` int(11) NOT NULL,
  `user_membership_log` int(11) NOT NULL,
  `user_register_ip` varchar(50) NOT NULL,
  `user_last_login` int(11) NOT NULL,
  `user_last_login_ip` varchar(50) NOT NULL,
  `user_company` varchar(100) NOT NULL,
  `user_phone` varchar(20) NOT NULL,
  `user_image` int(1) NOT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

DROP TABLE IF EXISTS `site_plugin_users_access`;
CREATE TABLE IF NOT EXISTS `site_plugin_users_access` (
  `access_id` int(11) NOT NULL AUTO_INCREMENT,
  `access_user` int(11) NOT NULL,
  `access_ip` varchar(50) NOT NULL,
  `access_last` int(11) NOT NULL,
  `access_times` int(11) NOT NULL,
  PRIMARY KEY (`access_id`),
  KEY `access_user` (`access_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `site_plugin_users_emails`;
CREATE TABLE IF NOT EXISTS `site_plugin_users_emails` (
  `email_id` int(11) NOT NULL AUTO_INCREMENT,
  `email_user` int(11) NOT NULL,
  `email_address` varchar(255) NOT NULL,
  `email_date` int(11) NOT NULL,
  PRIMARY KEY (`email_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `site_plugin_users_groups`;
CREATE TABLE IF NOT EXISTS `site_plugin_users_groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL,
  `group_code` varchar(50) NOT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

DROP TABLE IF EXISTS `site_plugin_users_log`;
CREATE TABLE IF NOT EXISTS `site_plugin_users_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `log_date` int(11) NOT NULL,
  `log_user` int(11) NOT NULL,
  `log_url` text NOT NULL,
  `log_description` text NOT NULL,
  `log_ip` varchar(50) NOT NULL,
  `log_module` varchar(255) NOT NULL,
  `log_module_type` int(11) NOT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=27 ;

ALTER TABLE  `site_plugin_users` ADD  `user_referrer_url` TEXT NOT NULL;

INSERT INTO `site_plugin_users_groups` (`group_id`, `group_name`, `group_code`) VALUES
(1, 'Facebook', ''),
(2, 'Local Users', '');


INSERT INTO `site_core_modules_user` (`mod_id`, `mod_parent`, `mod_order`, `mod_status`, `mod_invisible`, `mod_module`, `mod_module_code`, `mod_settings`, `mod_shopping`, `mod_protected`, `mod_background`, `mod_background_file`, `mod_set_protect_delete`, `mod_set_protect_edit`, `mod_set_protect_seo`, `mod_set_protect_default`, `mod_set_protect_m`, `mod_users`, `mod_user_position`, `mod_groups`, `mod_global`, `mod_external_target`, `mod_onepage_theme`, `mod_onepage_bgcolor`, `mod_onepage_image`, `mod_onepage_bgtype`) VALUES(1200, 1100, 1200, 1, 0, 126, 'text', NULL, 0, 0, 0, '', 0, 0, 0, 1, 0, '', 0, '', '', 0, 0, '', 0, 0);
INSERT INTO `site_core_modules_user` (`mod_id`, `mod_parent`, `mod_order`, `mod_status`, `mod_invisible`, `mod_module`, `mod_module_code`, `mod_settings`, `mod_shopping`, `mod_protected`, `mod_background`, `mod_background_file`, `mod_set_protect_delete`, `mod_set_protect_edit`, `mod_set_protect_seo`, `mod_set_protect_default`, `mod_set_protect_m`, `mod_users`, `mod_user_position`, `mod_groups`, `mod_global`, `mod_external_target`, `mod_onepage_theme`, `mod_onepage_bgcolor`, `mod_onepage_image`, `mod_onepage_bgtype`) VALUES(1201, 1100, 1201, 1, 0, 126, 'text', NULL, 0, 0, 0, '', 0, 0, 0, 1, 0, '', 0, '', '', 0, 0, '', 0, 0);
INSERT INTO `site_core_modules_user` (`mod_id`, `mod_parent`, `mod_order`, `mod_status`, `mod_invisible`, `mod_module`, `mod_module_code`, `mod_settings`, `mod_shopping`, `mod_protected`, `mod_background`, `mod_background_file`, `mod_set_protect_delete`, `mod_set_protect_edit`, `mod_set_protect_seo`, `mod_set_protect_default`, `mod_set_protect_m`, `mod_users`, `mod_user_position`, `mod_groups`, `mod_global`, `mod_external_target`, `mod_onepage_theme`, `mod_onepage_bgcolor`, `mod_onepage_image`, `mod_onepage_bgtype`) VALUES(1202, 1100, 1202, 1, 0, 126, 'text', NULL, 0, 0, 0, '', 0, 0, 0, 1, 0, '', 0, '', '', 0, 0, '', 0, 0);
INSERT INTO `site_core_modules_user` (`mod_id`, `mod_parent`, `mod_order`, `mod_status`, `mod_invisible`, `mod_module`, `mod_module_code`, `mod_settings`, `mod_shopping`, `mod_protected`, `mod_background`, `mod_background_file`, `mod_set_protect_delete`, `mod_set_protect_edit`, `mod_set_protect_seo`, `mod_set_protect_default`, `mod_set_protect_m`, `mod_users`, `mod_user_position`, `mod_groups`, `mod_global`, `mod_external_target`, `mod_onepage_theme`, `mod_onepage_bgcolor`, `mod_onepage_image`, `mod_onepage_bgtype`) VALUES(1203, 1100, 1203, 1, 0, 126, 'text', NULL, 0, 0, 0, '', 0, 0, 0, 1, 0, '', 0, '', '', 0, 0, '', 0, 0);



INSERT INTO `site_core_modules_user_lang` (`mod_id`, `lang_id`, `mod_name`, `mod_long_name`, `mod_urltitle`, `mod_url`, `mod_subtitle`, `mod_external_link`, `seo_title`, `seo_desc`, `seo_meta`) VALUES(1200, 1, 'Account Confirmed', 'Account Confirmed', 'Account Confirmed', 'account-confirmed', '', '', '', '', '');
INSERT INTO `site_core_modules_user_lang` (`mod_id`, `lang_id`, `mod_name`, `mod_long_name`, `mod_urltitle`, `mod_url`, `mod_subtitle`, `mod_external_link`, `seo_title`, `seo_desc`, `seo_meta`) VALUES(1201, 1, 'Invalid Confirm Link', 'Invalid confirm link', 'Invalid confirm link', 'invalid-confirm-link', '', '', '', '', '');
INSERT INTO `site_core_modules_user_lang` (`mod_id`, `lang_id`, `mod_name`, `mod_long_name`, `mod_urltitle`, `mod_url`, `mod_subtitle`, `mod_external_link`, `seo_title`, `seo_desc`, `seo_meta`) VALUES(1202, 1, 'Password Emailed', 'Password mailed', 'Password mailed', 'password-mailed', '', '', '', '', '');
INSERT INTO `site_core_modules_user_lang` (`mod_id`, `lang_id`, `mod_name`, `mod_long_name`, `mod_urltitle`, `mod_url`, `mod_subtitle`, `mod_external_link`, `seo_title`, `seo_desc`, `seo_meta`) VALUES(1203, 1, 'Invalid Recovery Link', 'Invalid recover link', 'Invalid recover link', 'invalid-recover-link', '', '', '', '', '');


INSERT INTO `site_core_texts` (`module_id`, `sub_id`, `text_image`) VALUES(1200, '', 0);
INSERT INTO `site_core_texts` (`module_id`, `sub_id`, `text_image`) VALUES(1201, '', 0);
INSERT INTO `site_core_texts` (`module_id`, `sub_id`, `text_image`) VALUES(1202, '', 0);
INSERT INTO `site_core_texts` (`module_id`, `sub_id`, `text_image`) VALUES(1203, '', 0);


INSERT INTO `site_core_texts_lang` (`module_id`, `lang_id`, `text_title`, `text_header`, `text_footer`, `seo_title`, `seo_desc`, `seo_meta`, `seo_conv_head`, `seo_conv_body`, `text_title_page`, `text_header_page`, `seo_title_page`, `seo_desc_page`, `seo_conv_head_page`, `seo_conv_body_page`) VALUES(1200, 1, 'Account Confirmed', '<p>Your account is now confirmed.</p>\r\n', '', 'Account Confirmed', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `site_core_texts_lang` (`module_id`, `lang_id`, `text_title`, `text_header`, `text_footer`, `seo_title`, `seo_desc`, `seo_meta`, `seo_conv_head`, `seo_conv_body`, `text_title_page`, `text_header_page`, `seo_title_page`, `seo_desc_page`, `seo_conv_head_page`, `seo_conv_body_page`) VALUES(1201, 1, 'Invalid Confirm Link', '<p>The confirmation link you are accessing doesnt exists or expired.</p>\r\n', '', 'Invalid Confirm Link', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `site_core_texts_lang` (`module_id`, `lang_id`, `text_title`, `text_header`, `text_footer`, `seo_title`, `seo_desc`, `seo_meta`, `seo_conv_head`, `seo_conv_body`, `text_title_page`, `text_header_page`, `seo_title_page`, `seo_desc_page`, `seo_conv_head_page`, `seo_conv_body_page`) VALUES(1202, 1, 'Password Emailed', '<p>We sent you a new password. Please check your email.</p>\r\n', '', 'Password Mailed', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `site_core_texts_lang` (`module_id`, `lang_id`, `text_title`, `text_header`, `text_footer`, `seo_title`, `seo_desc`, `seo_meta`, `seo_conv_head`, `seo_conv_body`, `text_title_page`, `text_header_page`, `seo_title_page`, `seo_desc_page`, `seo_conv_head_page`, `seo_conv_body_page`) VALUES(1203, 1, 'Invalid Recover Link', '<p>The link you are trying to access doesnt exists or expired. Please click on recover password again to regenerate the link.</p>\r\n', '', 'Invalid Recover Link', '', '', '', '', '', '', '', '', '', '');





INSERT INTO `site_core_widgets` (`widget_id`, `widget_type`, `widget_type_name`, `widget_module`, `widget_module_type`, `widget_settings`, `widget_status`, `widget_system`, `widget_cache`, `widget_show_title`, `widget_perm`, `widget_perm_groups`, `widget_perm_memberships`, `widget_disable_title`, `widget_device`) VALUES
(99, 2, 'User Menu', 100, 2, '', 1, 0, 0, 1, 1, '', '', 0, '1,2,3');


INSERT INTO `site_core_widgets_lang` (`widget_id`, `lang_id`, `widget_name`, `widget_set_lang`, `widget_cache_data`, `widget_cache_update`) VALUES
(99, 1, 'My Account', 'YToxOntzOjc6ImxhbmdfaWQiO3M6MToiMSI7fQ==', '', 0);


INSERT INTO `site_core_layouts_items` (`layitem_id`, `layitem_order`, `layitem_layout`, `layitem_widget`, `layitem_column`) VALUES
(4, 4, 4, 99, 1);
