<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CBreadcrumbImages extends CPlugin{
	
	var $tplvars; 

	function CBreadcrumbImages() {
		//$this->CPlugin($db, $tables , $templates);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetBackground($mod_id , $system = false) {
		global $_CONF;


		if ($system) {

			if ($mod_id != null) {
				$img = $this->db->QFetchArray(
					"SELECT * FROM {$this->tables['plugin:breadcrumbimages']} WHERE find_in_set({$mod_id} , image_modules_global) ORDER BY rand() limit 1"
				);
			}
			
		} else {
			
			$img = $this->db->QFetchArray(
				"SELECT * FROM {$this->tables['plugin:breadcrumbimages']} WHERE find_in_set({$mod_id} , image_modules) ORDER BY rand() limit 1"
			);
		}

		//load the default if exits
		if (!is_array($img)) {
			$img = $this->db->QFetchArray(
				"SELECT * FROM {$this->tables['plugin:breadcrumbimages']} WHERE image_default=1 ORDER BY rand() limit 1"
			);
		}
		
		if (is_array($img)) {
			$this->__init();

			if ($img["image_img"]) {
				$css[] = "background-image: url(upload/breadcrumbimages/{$img[image_id]}.jpg)";
				$css[] = "width: 100%";
				$css[] = "height: 100%";
				$css[] = "-webkit-background-size: {$img[image_size]}";
				$css[] = "background-size: {$img[image_size]}";
				$css[] = "background-position: {$img[image_posx]} {$img[image_posy]}";
				$css[] = "background-repeat: {$img[image_repeat]}";
				$css[] = "background-attachment: " . ($img["image_fixed"] ? "fixed" : "scroll");
			}

			if ($img["image_color"]) {
				$rgb = $this->plugins["layouts"]->hex2rgb($img["image_color"]);
				$css[] = "background-color: rgba({$rgb[r]},{$rgb[g]},{$rgb[b]},{$img[image_alpha]})";
			}

			$class = $img["image_inverted"] ? $this->private->templates["main"]->BlockReplace("Inverted") : "";

			if ($img["image_overlay"]) {
				$class .= " " . $this->plugins["skineditor"]->Overlay($img["image_overlay"]);
			}
			

			return array(
				"css"	=> is_array($css) ? implode(";" , $css) : "",
				"class"	=>	$class,
				"file"	=>  $img["image_img"] ? "upload/breadcrumbimages/{$img[image_id]}.jpg" : "",
			);
		}
		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onGlobalHooksExecute($module) {
		global $_LANG_ID , $_TSM;


		if ($module["mod_id"]) {
			$bg  = 	$this->GetBackground($module["mod_id"]);
		} elseif ($module["module_id"]) {
			$bg  = 	$this->GetBackground($module["module_id"] , true);
		} else {
			$bg  = 	$this->GetBackground(null , true);
		}

		$_TSM["BREADCRUMBIMAGES_CLASS"] = $bg["class"];
		$_TSM["BREADCRUMBIMAGES_CSS"] = $bg["css"];
		$_TSM["BREADCRUMBIMAGES_FILE"] = $bg["file"];
	}


	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"main"				=> "main.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}
	}

}

?>