<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CBreadCrumb extends CPlugin{
	
	var $tplvars; 

	function CBreadCrumb() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"main"					=> "main.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

//		$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("comments");


	} 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Remove() {
		$this->title = "";
		$this->bpath = "";

		$this->removed = true;


		global $_TSM;

		$_TSM["BREADCRUMB"] = "";

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Add($title , $path = array(), $protected = false , $module = null) {

		$this->title = $title;
		$this->bpath = $path;

		$this->_protected = $protected;
		$this->_module = $module;
	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render() {

		$this->__init();

		//if no title was set then return a clean path

		if (!is_array($this->title) && $this->title) {
			$this->title = array(
				"title"		=> $this->title,
				"subtitle"	=> "",
				"show"		=> "1",
			);
		}
		

		if (
			(is_array($this->title) && !($this->title["title"] || $this->title["subtitle"])) || 
			(!is_array($this->title) && !$this->title)	
		){
			return $this->private->templates["main"]->blockReplace("Empty");
		}


		if (is_array($this->title) && !$this->title["show"]) {
			return "";
		}
		

//		if ((is_array($this->title) && !$this->title["title"]) || (!is_array($this->title) && !$this->title)) {
//		}

		if ($this->removed) {
			return "";
		}
		

		if (is_Array($this->bpath)) {

			if ($this->_protected) {

				//array_unshift($this->bpath , array("link" => "/account/" , title=)

				$tmp = $this->plugins["users"]->AccountLink();
				$path[$tmp["link"]] = $tmp["title"];

				foreach ($this->bpath as $key => $val) {
					$path[$key] = $val;
				}


				$this->bpath = $path;

				$path = "";
			}
			
			foreach ($this->bpath as $key => $val) {
				$path .= $this->private->templates["main"]->blockReplace(
					"PathElement",
					array(
						"link"	=> $key, 
						"title"	=> $val
					)
				);
			}


			if ($this->_module["home"]) {
				$path = "";
			}
			

			$path_html = $this->private->templates["main"]->blockReplace(
				"Path",
				array(
					"data"	=> $path, 
				)
			);			
			
		}
		
		
		return $this->private->templates["main"]->blockReplace(
			"Main" , 
			array(
				"title"		=> is_array($this->title) ? $this->title["title"] : "",
				"subtitle"	=> 
					is_array($this->title) && $this->title["subtitle"]  && $this->private->templates["main"]->BlockExists("Subtitle") ? 
					$this->private->templates["main"]->BlockReplace(
						"Subtitle",
						array(
							"header"	=> $this->title["subtitle"]
						)
					)  : "",

				"path"	=> $path_html,
			)
		);
	} 

	
	function onGlobalHooksExecute($module) {
		global $_TSM;

		$_TSM["BREADCRUMB"] = $this->Render();
	}

}

?>