<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CSliders extends CPlugin{
	
	var $tplvars; 

	function CSliders() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onGlobalHooksExecute($module) {
		global $_LANG_ID , $_TSM , $base;


		//shortcodes
		$this->plugins["shortcodes"]->dynamic[] = array(
			"pattern"	=> '/\[mediainsert=([0-9]+)\]/',
			"method"	=> array(&$this, "shortcode")
		);


		if ($this->removed == true) {
			$_TSM["PUB:SLIDER"] = "";
			return false;
		}
		

		//tablet
		if ($base->device->isTablet()) {
				$cond = " AND find_in_set(2,slider_device) ";
		} elseif ($base->device->isMobile()) {
				//phone
				$cond = " AND find_in_set(3,slider_device) ";
			} else {
				//desktop
				$cond = " AND find_in_set(1,slider_device) ";
			}
		
		if ($module["mod_id"]) {
			$slider = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:sliders']}
				WHERE 
					slider_status = 1 AND
					find_in_set({$module[mod_id]} , slider_modules) AND
					slider_default = 0
					{$cond}
					
				ORDER BY rand() limit 1"
			);

		} elseif ($module["module_id"]) {
			$slider = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:sliders']} 
				WHERE 
					slider_status = 1 AND
					find_in_set({$module[module_id]} , slider_modules_global) AND 
					slider_default = 0
					{$cond}
					
				ORDER BY rand() limit 1"
			);
		}

		//try for a default slider
		if (!is_array($slider)) {
			$slider = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:sliders']}
				WHERE 
					slider_default = 1 AND 
					slider_status = 1 
					{$cond}
					
				ORDER BY rand() limit 1"
			);
		}			

		$this->__init();

		if (is_array($slider)) {

			if (!$slider["slider_show_header"]) {
				$this->module->plugins["breadcrumb"]->Remove();			
			}
			
			$_TSM["PUB:SLIDER"] = $this->Render($slider);
		} else {
			$_TSM["PUB:SLIDER"] = "";
		}

	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Remove() {
		global $_TSM;

		$_TSM["PUB:SLIDER"] = "";
		$this->removed = true;
	}
	

	function ShortCode($matches) {
		return $this->Render($matches[1]);
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($slider) {

		if (!is_array($slider)) {
			$slider = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:sliders']}
				WHERE 
					slider_status = 1 AND
					slider_id = %d
				",
				array (
					$slider
				)
			);
		}

		if (is_array($slider)) {

			if (is_object($this->plugins[$slider["slider_module"]])) {
				return $this->plugins[$slider["slider_module"]]->Render($slider["slider_sid"]);
			} else {
				//remove slider
				$this->db->Query("DELETE FROM {$this->tables['plugin:sliders']} WHERE slider_id={$slider[slider_id]}");
			}
			
		}
		
	}
	
	
}

?>