<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CSettings extends CPlugin{
	
	var $tplvars; 

	function CSettings() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		$this->__init();
		$this->GoogleSettings();
		$this->FacebookSettings();
		$this->BingSettings();
		$this->GenericSettings();
	}


	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"google"		 => "google.htm",
			"facebook"		 => "facebook.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GoogleSettings() {

		global $_TSM;

		//google webmaster tools
		if ($this->vars->data["set_google_wa_code"]) {
			$_TSM["PUB:SEO_CONV_HEAD"] .= $this->vars->data["set_google_wa_code"];
		
		}

		//google analytics code
		if ($this->vars->data["set_google_analytics_status"]) {

			switch ($this->vars->data["set_google_analytics_code_type"]) {
				//universall code
				case "1":
					$_TSM["PUB:SEO_CONV_BODY"] .= $this->private->templates["google"]->blockReplace(
						"Universal",
						array(
							"SET_GOOGLE_ANALYTICS_ID"	=> $this->vars->data["set_google_analytics_id"],
						)
					);
				break;

				//classic code
				case "2":
					$_TSM["PUB:SEO_CONV_BODY"] .= $this->private->templates["google"]->blockReplace(
						"Standard",
						array(
							"SET_GOOGLE_ANALYTICS_ID"	=> $this->vars->data["set_google_analytics_id"],
						)
					);
				break;

				//custom code
				case "3":
					$_TSM["PUB:SEO_CONV_BODY"] .= $this->vars->data["set_google_analytics_script"];
				break;

			}
			
		}			
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function FacebookSettings() {
		global $_TSM;
		if ($this->vars->data["set_facebook"]) {
			$_TSM["PUB:SEO_CONV_BODY"] .= $this->private->templates["facebook"]->blockReplace(
				"Code",
				array(
					"SET_FACEBOOK_APP"	=> $this->vars->data["set_facebook_app"],
				)
			);		
		}		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GenericSettings() {
		global $_TSM;

		$_TSM["PUB:SEO_CONV_HEAD"] .= $this->vars->data["set_generic_head"];
		$_TSM["PUB:SEO_CONV_BODY"] .= $this->vars->data["set_generic_body"];
	}
	

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function BingSettings() {
		global $_TSM;

		$_TSM["PUB:SEO_CONV_HEAD"] .= $this->vars->data["set_bing_code"];
	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onGlobalHooksExecute($module) {
		global $_CONF , $_TSM;

		//check for protected module

		$changed	= false;
		$protocol	= ($_SERVER["HTTPS"] ? "https://" : "http://" );
		$domain		=  $_SERVER["HTTP_HOST"];
		$link		= $_SERVER["REQUEST_URI"];			


		$prefix = strtolower(substr($_SERVER["HTTP_HOST"], 0 , 4));

		if (( $prefix == "www.") && ($this->vars->data["set_site_prefix"] != "www")) {
			$changed = true;
			$domain		=  substr($_SERVER["HTTP_HOST"] , 4);
		}
		
		if (( $prefix != "www.") && ($this->vars->data["set_site_prefix"] == "www")) {
			$changed = true;
			$domain		=  "www." . $_SERVER["HTTP_HOST"] ;
		}


		//check for protocols
		if ($module["mod_id"]) {

			//protected modules
			if ($module["mod_protected"] && $this->vars->data["set_site_protocol_protected"] && !$_SERVER["HTTPS"]) {
				$changed = true;
				$protocol = "https://";
			}

			if ($module["mod_protected"] && !$this->vars->data["set_site_protocol_protected"] && $_SERVER["HTTPS"]) {
				$changed = true;
				$protocol = "http://";
			}			


			//public modules
			if (!$module["mod_protected"] && $this->vars->data["set_site_protocol"] && !$_SERVER["HTTPS"]) {
				$changed = true;
				$protocol = "https://";
			}

			if (!$module["mod_protected"] && !$this->vars->data["set_site_protocol"] && $_SERVER["HTTPS"]) {
				$changed = true;
				$protocol = "http://";
			}			



		} else /*if ($module["module_id"])*/ {

			//protected modules
			if ($module["module_protected"] && $this->vars->data["set_site_protocol_protected"] && !$_SERVER["HTTPS"]) {
				$changed = true;
				$protocol = "https://";
			}

			if ($module["module_protected"] && !$this->vars->data["set_site_protocol_protected"] && $_SERVER["HTTPS"]) {
				$changed = true;
				$protocol = "http://";
			}			

			//public modules
			if (!$module["module_protected"] && $this->vars->data["set_site_protocol"] && !$_SERVER["HTTPS"]) {
				$changed = true;
				$protocol = "https://";
			}

			if (!$module["module_protected"] && !$this->vars->data["set_site_protocol"] && $_SERVER["HTTPS"]) {
				$changed = true;
				$protocol = "http://";
			}			

		}

		if ($changed) {
			header ( "Location: {$protocol}{$domain}{$link} ", true, 301 );
			exit();
		}

		//favicon 

		if (file_exists("upload/favicon.png")) {
			$this->plugins["seo"]->AppendToHead(
				'<link rel="icon" type="image/png" href="'. $_CONF["url"] . 'upload/favicon.png" />'
			);
		}		



		//cache control 
		if (file_exists("upload/conf/js_cache")) {
			$_TSM["OPT_JS_NOCACHE"] = "?" . time();
		} else 
			$_TSM["OPT_JS_NOCACHE"] = "";
		
		if (file_exists("upload/conf/css_cache")) {
			$_TSM["OPT_CSS_NOCACHE"] = "?" . time();
		} else 
			$_TSM["OPT_CSS_NOCACHE"] = "";
			
	}
	

}

?>