<?php
/*
	Stempora web framework
	copyright (c) 2002-2013 Stempora
		web:  www.stempora.com
		mail: support@stempora.com
*/


class CFormsQueue {
	
	function CFormsQueue($datafile , $fail = "", &$template = null, $batch = 10) {

		$this->fail = $fail;
		$this->template = $template;

		if ($datafile != null) 
			$this->datafile = $datafile;

		$this->batch = $batch;

		if (!is_object($this->template)) {
			$this->template = new CTemplateDynamic("templates/form.queue.htm");
		}
		

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AddFunction($hook , $action = array()) {
		$this->functions[$hook] = $action;
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Run() {

		set_time_limit(0);

		//read the information
		$this->loadConfig();

		$status = $this->readData();

		if (!is_array($status)){
			//return $status;
		}

		

		//run batches only when i have json requests
		if ($_GET["json"]) {
			$this->runBatch();
		}
		

		return $this->runStatus();
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	private function loadConfig() {

		$data = call_user_func($this->functions["batch"], $this->config , $val);

		if ($this->functions["datafile"]) {
			$this->config = call_user_func($this->functions["datafile"] , "load");
		} else {

			if (!file_exists($this->datafile)) {
				$this->Fail();
			}
			

			$file = file($this->datafile);


			$this->config = array(
				"file"			=> trim($file[0]),
				"vars"			=> unserialize(trim($file[1])),
				"total"			=> trim($file[2]),
				"last"			=> trim($file[3]),
				"new"			=> trim($file[4]),
				"duplicates"	=> trim($file[5]),
				"errors"		=> trim($file[6]),
				"batches"		=> trim($file[7]),
				"current"		=> trim($file[8]),
				"ignored"		=> trim($file[9]),
				"updated"		=> trim($file[10]),
				"batch"			=> $this->batch,
			);

		}		


		return $this->config;

	}

	private function SaveConfig(){

		if ($this->functions["datafile"]) {
			call_user_func($this->functions["datafile"] , $this->config , "store");
		} else{
			saveFileContents(
				$this->datafile , 
				$this->config["file"] . "\n" .
				serialize($this->config["vars"]) . "\n" .
				$this->config["total"] . "\n" .
				$this->config["last"] . "\n" .
				$this->config["new"] . "\n" .
				$this->config["duplicates"] . "\n" .
				$this->config["errors"] . "\n" . 
				$this->config["batches"] . "\n" . 
				$this->config["current"] . "\n".
				$this->config["ignored"] . "\n" . 
				$this->config["updated"] . "\n"
			);
		}

		return true;
	}
	

	private function ReadData() {

		//check if the file was preproceeded
		if ($this->config["batches"]) {
			return true;
		} else {		
			//start reading the data
			$this->config = call_user_func($this->functions["data"], $this->config);

			if (!is_array($this->config)) {
			//	return $this->config;
			}
			

			$this->SaveConfig();

		}
	}

	private function runBatch() {

		global $_CONF;


		$data = call_user_func($this->functions["batch"], $this->config , $val);

		if (is_array($data)) {
			foreach ($data as $key => $val) {


				$status = call_user_func($this->functions["store"], $this->config , $val);

				switch ($status) {
					case "1":
						$this->config["new"] ++;
					break;

					case "2":
						$this->config["updated"] ++;
					break;

					case "3":
						$this->config["errors"] ++;
					break;

					case "4":
						$this->config["ignored"] ++;
					break;

				}
			}				
		}			

		$this->config["current"]++;

		if ($this->config["current"] >= $this->config["batches"]) {
			$this->runCleanup();
		}


	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function RunStatus() {

/*
		if (is_array($this->config)) {
			if ($this->config["current"] >= $this->config["batches"]) {

				debug($this->config,1);
				$this->runCleanup();
			}
		}
		
*/

		$config = $this->config;


		if ($config["current"] && $config["batches"]) {
			if ($config["batches"] > 0) {
				$data["progress"] = ceil(100 *  $config["current"] / $config["batches"]);
				$data["n_progress"] = 100 - ceil(100 *  $config["current"] / $config["batches"]);

				//$this->runCleanup();
			} else {
				$data["progress"] = 100;
				$data["n_progress"] = 0;
			}
			
		} else {
			$data["progress"] = "0";
			$data["n_progress"] = "100";
		}

		$data["total"]		= (int)$config["total"];
		$data["left"]		= (int)$config["total"] - ($config["new"] + $config["duplicates"] + $config["errors"] + $config["updated"]);
		$data["done"]		= $data["total"] - $data["left"];

		$data["errors"]		= (int)$config["errors"];
		$data["duplicates"] = (int)$config["duplicates"];
		$data["new"]		= (int)$config["new"];
		$data["updated"]	= (int)$config["updated"];
		$data["current"]	= (int)$config["current"];
		$data["ignored"]	= (int)$config["ignored"];


		if ($this->config["current"] < $this->config["batches"]) {
			$this->SaveConfig();
		}


		if ($_GET["json"]) {
			return json_encode($data);
		}

		$vars = $_GET;
		$vars["json"] = "true";
		//$vars["current"] = $this->config["current"];

		$data["link"] = http_build_query($vars);
		
		return $this->template->Blockreplace(
			"Update" , 
			$data
		);

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function runCleanup() {

		if ($this->functions["finish"]) {
			$data = call_user_func($this->functions["finish"], $this->config);
		}

		if ($this->functions["datafile"]) {
			call_user_func($this->functions["datafile"] , $this->config , "delete");
		}
	
	}

	private function Fail(){
		echo "<script>parent.location='{$this->fail}';</script>'";
		die();
	}
	
}


?>