<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2016 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CServicesWidgetServices extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "2",
		"name"	=> "Services w/ Optional Carousel",
	);

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;

		switch ($widget["settings"]["set_type"]) {
			default:
			case "1":
				$order = " i.cat_id DESC ";
				$cnt = $widget["settings"]["set_items"];
			break;
			

			case "2":
				$order = " rand() ";
				$cnt = $widget["settings"]["set_items"];
			break;

			case "3":

				if (!$widget["settings"]["set_item"]) {
					return "";
				}
				
				$cond = " AND i.cat_id IN ({$widget[settings][set_item]}) ";
				$order = "i.cat_id ASC";

				$cnt = 99999;
			break;
		}


		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:services_cats']} as i,
				{$this->tables['plugin:services_cats_lang']} as il
			WHERE 				
				i.cat_id = il.cat_id AND 
				il.lang_id={$widget[lang_id]} AND 
				i.module_id={$widget[widget_module]} 

			ORDER BY  {$order} 
			LIMIT {$cnt}" 
		);

		

		if (!is_array($items)) {
			return "";
		}

		if ($widget["settings"]["set_type"] == "3") {
			$items = SortByKeys($items , "cat_id" , $widget["settings"]["set_item"]);
		}

			
		if (is_array($items)) {
			$items = $this->module->ProcessItems($items , $this->tpl , $widget);
		}

		
		return $this->tpl->blockReplace(
			"Main",
			array(
				"items"	=> $base->html->Table(
					$this->tpl, 
					"" , 
					$items
				),
				"class"	=> $this->tpl->blockreplace($widget["settings"]["set_carousel"] ? "Carousel" :"List"),

			),
			$widget,
			$widget["settings"],
			$widget["mod_settings"]
		);

	}
	
}


?>